#include <ansi_c.h>
#include "AccessHW.h"
#include <stdio.h>


/* DO NOT CHANGE PARAMETERS BELOW THIS POINT */
#define WRITE_SUCCESS 1

/* PPI A */
#define A_PORTA_ADDR  0x00 // Port A, aka. Port 0
#define A_PORTB_ADDR  0x01 // Port B, aka. Port 1
#define A_PORTC_ADDR  0x02 // Port C, aka. Port 2
#define A_CNFG_ADDR   0x03 // Config Register

/* PPI B if using PCI-DIO-96*/
#define B_PORTA_ADDR 0x04 // PPI B Port A, aka. Port 3
#define B_PORTB_ADDR 0x05 // PPI B Port B, aka. Port 4
#define B_PORTC_ADDR 0x06 // PPI B Port C, aka. Port 5
#define B_CNFG_ADDR  0x07 // PPI B Config Port

/* PPI C if using PCI-DIO-96*/
#define C_PORTA_ADDR 0x08 // PPI C Port A, aka. Port 6
#define C_PORTB_ADDR 0x09 // PPI C Port B, aka. Port 7
#define C_PORTC_ADDR 0x0A // PPI C Port C, aka. Port 8
#define C_CNFG_ADDR  0x0B // PPI C Config Port

/* PPI D if using PCI-DIO-96*/
#define D_PORTA_ADDR 0x0C // PPI D Port A, aka. Port 9
#define D_PORTB_ADDR 0x0D // PPI D Port B, aka. Port 10
#define D_PORTC_ADDR 0x0E // PPI D Port C, aka. Port 11
#define D_CNFG_ADDR  0x0F // PPI D Config Port

/* Counter/Timer */
#define CLOCKA	     0x10 // Clock or Counter 0
#define CLOCKB       0x11 // Clock or Counter 1
#define CLOCKC       0x12 // Clock or Counter 2
#define	CLOCK_CTRL   0x13 // Clock or Counter Control

/* Interrupt control */
#define INTR_CTRL1   0x14 // First interrupt control reg
#define INTR_CTRL2   0x15 // Second interrupt control reg
#define INTR_CLEAR   0x16 // Interrupt Clear Register

unsigned int boardAddress = 0xFEDFF000;    
unsigned int MITEAddress = 0xFEDFE000;    

int Board_Write_8bit(int offset, int valueToWrite);
int ConfigureMITE(void);

void main()
{
	char ch;
/*
* Input MITE Address and Board Address from user.
* These values are stored in the BAR0 and BAR1 registers and are assigned
* by the BIOS.  You may prefer to implement specific calls to read this data from
* the registry in Win95 or WinNT or another mechanism.
*/
	printf("Input the memory addresses assigned to the PCI-MIO card.\n");
	printf("If running Windows 95 or Windows NT, you may refer to the device manager or Windows NT Resources\n");
	printf("to find these values.  The first value assigned will be the MITE address\n");
	printf("and the second will be the Board address.\n");
	printf("\nEnter the MITE address in hexadecimal notation, i.e. FEDFE000 ");
	scanf("%X",&MITEAddress);
	printf("\nEnter the board address in hexadecimal notation, i.e. FEDFF000 ");
	scanf("%X",&boardAddress);
	ch = getchar();
	printf("\nYou entered MITEAddress = 0x%X and the Board Address = 0x%X\n",MITEAddress,boardAddress);
	
	printf("If this is correct, hit 'Y' \n");
	
	scanf("%c",&ch);
	ch = tolower (ch);
	if ((ch!='y'))
	{
		printf("Try again later - Goodbye");
		return;
	}	

/* 
* PCI configuration for the board.
*/
	if (ConfigureMITE() != WRITE_SUCCESS)
		printf("Error configuring MITE.\n");
	
	// Configure ports for output.
	if (Board_Write_8bit(A_CNFG_ADDR,0x80) != WRITE_SUCCESS)
		printf("Error writing\n");

	// Write to port A.
	if (Board_Write_8bit(A_PORTA_ADDR,0x00) != WRITE_SUCCESS)
		printf("Error writing\n");
	printf("done");
}


int Board_Write_8bit(int offset, int valueToWrite)
{
	printf("Address written = %X and value written = %X\n",offset + boardAddress,valueToWrite); 	
	return (WriteToMemory8 (offset + boardAddress, valueToWrite));
}
	
int ConfigureMITE()
{
	int valueToWrite = boardAddress|0x80;
	printf("Address written = %X and value written = %X\n",MITEAddress+0xC0,valueToWrite); 	
	return (WriteToMemory32 (MITEAddress+0xC0, valueToWrite));
}
